#include <qapp.h>
#include <qmenubar.h>
#include <qlined.h>
//#include <qmlined.h>
#include <qscrbar.h>
#include <qlist.h>

#include "output.h"

#include "server.h"
#include "query.h"
#include "channel.h"

class MainWidget : public QWidget
{
 Q_OBJECT
 public:
  MainWidget(QWidget *parent=0, const char *name=0);

 public slots:
  void fileConnect();
  void fileSetup();
  void fileOptions();
  void editCut();
  void editCopy();
  void editPaste();
  void editClear();
  void dccSend();
  void dccGet();
  void dccOptions();
  void helpAbout();
  
  void putMessage(ircMsg msg);
  void putNotice(ircMsg msg);

  void putQuery(ircMsg msg);
  void delQuery(QString nick);

  void newChannel(QString channel);
  void delChannel(QString channel);
  void putChannelMessage(ircMsg msg);
  
  void handleJoin(QString channel, QString nick);
  void handlePart(QString channel, QString nick);
  void handleQuit(QString nick, QString q_msg);
  void handleTopic(QString channel, QString topic);

  void handleNickChange(QString old_n, QString new_n);

  void processInput();

 private:
  void putLine(QString line);
  
  ircServer *svr; 
  QList<queryWindow> queryList;
  QList<channelWindow> channelList;
  QMenuBar *mainMenu;
  QLineEdit *inputLine;
  OutputWidget *statusWindow;
};


