/* xIRCh IRC client for X Windows */
/* ------------------------------ */
/*   written by:                  */
/*      Derek Konigsberg          */
/* ------------------------------ */

#include <iostream.h>
#include <stdio.h>
#include <qapp.h>
#include <qwidget.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qpushbt.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qfont.h>
#include <qlined.h>
#include <qmlined.h>
#include <qmsgbox.h>
#include <qscrbar.h>
#include <ctype.h>
#include <qpainter.h>
#include <qsocknot.h>
#include <qstring.h>
#include <qtimer.h>

#include "xirch.h"

MainWidget::MainWidget(QWidget *parent, const char *name)
           :QWidget(parent,name)
{
  setCaption("xIRCh v0.11");

  QPopupMenu *file = new QPopupMenu;
  CHECK_PTR(file);
  file->insertItem("Connect",this,SLOT(fileConnect()));
  file->insertSeparator();
  file->insertItem("Setup",this,SLOT(fileSetup()));
  file->insertItem("Options",this,SLOT(fileOptions()));
  file->insertSeparator();
  file->insertItem("Exit",qApp,SLOT(quit()));

  QPopupMenu *edit = new QPopupMenu;
  CHECK_PTR(edit);
  edit->insertItem("Cut",this,SLOT(editCut()));
  edit->insertItem("Copy",this,SLOT(editCopy()));
  edit->insertItem("Paste",this,SLOT(editPaste()));
  edit->insertItem("Clear",this,SLOT(editClear()));

  QPopupMenu *dcc = new QPopupMenu;
  CHECK_PTR(dcc);
  dcc->insertItem("Send",this,SLOT(dccSend()));
  dcc->insertItem("Get",this,SLOT(dccGet()));
  dcc->insertSeparator();
  dcc->insertItem("Options",this,SLOT(dccOptions()));

  QPopupMenu *help = new QPopupMenu;
  CHECK_PTR(help);
  help->insertItem("About",this,SLOT(helpAbout()));

  mainMenu = new QMenuBar(this);
  CHECK_PTR(mainMenu);
  mainMenu->insertItem("&File",file);
  mainMenu->insertItem("&Edit",edit);
  mainMenu->insertItem("&DCC",dcc);
  mainMenu->insertSeparator();
  mainMenu->insertItem("&Help",help);

  inputLine = new QLineEdit(this,"Input Line");
  CHECK_PTR(inputLine);
  inputLine->setGeometry(1,179,498,20);
  connect(inputLine,SIGNAL(returnPressed()),SLOT(processInput()));
  
  statusWindow = new OutputWidget(this,"Status Window");
  CHECK_PTR(statusWindow);
  statusWindow->setGeometry(1,30,498,145);
//  statusWindow->setReadOnly(TRUE);
//  statusWindow->setAutoUpdate(TRUE);
//  statusScroll = new QScrollBar(QScrollBar::Vertical,this,"Status Scrollbar");
//  statusScroll->setGeometry(480,30,18,145);
 
  setMinimumSize(500,200);
  setMaximumSize(500,200);

  svr = new ircServer(this,"Server");

  queryList.setAutoDelete(TRUE);
  channelList.setAutoDelete(TRUE);

// slot for general status window messages  
  connect(svr,SIGNAL(generalMsg(ircMsg)),
              SLOT(putMessage(ircMsg)));

// slot for query (private chat) messages
  connect(svr,SIGNAL(queryMsg(ircMsg)),
              SLOT(putQuery(ircMsg)));

// slot for notices
  connect(svr,SIGNAL(noticeMsg(ircMsg)),
              SLOT(putNotice(ircMsg)));

// slot for nick changes
  connect(svr,SIGNAL(nickChange(QString,QString)),
              SLOT(handleNickChange(QString,QString)));

// slot for new channel windows
  connect(svr,SIGNAL(newChannel(QString)),
              SLOT(newChannel(QString)));

// slot for closing channel windows
  connect(svr,SIGNAL(delChannel(QString)),
              SLOT(delChannel(QString)));

// slot for people joining a channel
  connect(svr,SIGNAL(joinChannel(QString,QString)),
              SLOT(handleJoin(QString,QString)));

// slot for people parting a channel
  connect(svr,SIGNAL(partChannel(QString,QString)),
              SLOT(handlePart(QString,QString)));

// slot for channel messages
  connect(svr,SIGNAL(channelMsg(ircMsg)),
              SLOT(putChannelMessage(ircMsg)));

// slot for channel topic changes
  connect(svr,SIGNAL(channelTopic(QString,QString)),
              SLOT(handleTopic(QString,QString)));

// slot for people quitting from the server
  connect(svr,SIGNAL(quitServer(QString,QString)),
              SLOT(handleQuit(QString,QString)));

}

void MainWidget::fileConnect()
{
 putLine("Attempting to connect... (irc.ais.net:6667)");
 svr->setNick("Test521");
 if(svr->connect_to("irc-2.mit.edu",6667)==0)
  putLine("Error connecting to server");
 else
 {
  putLine("Connected!");
 }

}

void MainWidget::fileSetup()
{
 QMessageBox mb;
 mb.setText("Sorry, feature not implemented yet.");
 mb.show();
// setupDialog m(this,"Setup");
// m.exec();
}

void MainWidget::fileOptions()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::editCut()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::editCopy()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::editPaste()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::editClear()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::dccSend()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::dccGet()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::dccOptions()
{
  QMessageBox mb;
  mb.setText("Sorry, feature not implemented yet.");
  mb.show();
}

void MainWidget::helpAbout()
{
  QMessageBox mb;
  mb.setText("X Windows IRC Hack (xIRCh)\nVersion 0.11\nWritten by:\nDerek Konigsberg");
  mb.show();
}

void MainWidget::processInput()
{
 svr->userInput(inputLine->text());
 inputLine->setText("");
}

void MainWidget::putLine(QString line)
{
 statusWindow->InsertText(line);
 statusWindow->NewLine();
 
// statusWindow->setCursorPosition(statusWindow->numLines(),0,FALSE);
// statusWindow->repaint();
}

void MainWidget::putMessage(ircMsg msg)
{
 putLine(msg.text);
}

void MainWidget::newChannel(QString channel)
{
 channelWindow *tmp;

 channelList.append(new channelWindow(channel));
 tmp=channelList.current();
 connect(tmp,SIGNAL(newInput(QString)),svr,SLOT(userInput(QString)));
 connect(svr,SIGNAL(delChannel(QString)),SLOT(delChannel(QString)));
}

void MainWidget::delChannel(QString channel)
{
 channelWindow *tmp;
 tmp=channelList.first();
 while(tmp!=0)
 {
  if(channel==tmp->getName())
  {
   tmp->hide();
   disconnect(tmp);
   channelList.remove();
   break;
  }
  tmp=channelList.next();
 }
}

void MainWidget::putChannelMessage(ircMsg msg)
{
 channelWindow *tmp;
 tmp=channelList.first();
 while(tmp!=0)
 {
  if(msg.channel==tmp->getName())
  {
   if(msg.text!="")
    tmp->putLine("<"+msg.nick+"> "+msg.text);
   break;
  }
  tmp=channelList.next();
 }
}

void MainWidget::handleJoin(QString channel, QString nick)
{
 channelWindow *tmp;
 tmp=channelList.first();

// puts("'"+channel+"' gets '"+nick+"'");

 while(tmp!=0)
 {
  if(channel==tmp->getName())
   if(tmp->nickExists(nick)==FALSE)
   {
//    puts("Joining person... (bug not in this block)");
    tmp->nickJoin(nick);
    tmp->putLine(nick+" has joined...");
    break;
   }
  tmp=channelList.next();
 }
}

void MainWidget::handlePart(QString channel, QString nick)
{
 channelWindow *tmp;
// puts(channel); puts(nick); puts("----");
 tmp=channelList.first();
 while(tmp!=0)
 {
  if(channel==tmp->getName())
  {
   tmp->nickPart(nick);
   tmp->putLine(nick+" has parted...");
   break;
  }
  tmp=channelList.next();
 }
}

void MainWidget::handleQuit(QString nick, QString q_msg)
{
 channelWindow *tmp;
 tmp=channelList.first();
 while(tmp!=0)
 {
  if(tmp->nickExists(nick))
   tmp->nickPart(nick);
  tmp=channelList.next();
 }
 putLine(nick+" has quit ("+q_msg+")");
}

void MainWidget::handleTopic(QString channel, QString topic)
{
 channelWindow *tmp;
 tmp=channelList.first();
 while(tmp!=0)
 {
  if(channel==tmp->getName())
  {
   tmp->setTopic(topic);
   break;
  }
  tmp=channelList.next();
 }
}

void MainWidget::putQuery(ircMsg msg)
{
 queryWindow *tmp;
 bool flag=FALSE;
 tmp=queryList.first();
 if(msg.channel="")
 {
  while(tmp!=0)
  {
   if(msg.nick==tmp->getNick())
   {
    if(msg.text!="")
     tmp->putLine("<"+msg.nick+"> "+msg.text);
    flag=TRUE;
    break;
   }
   tmp=queryList.next();
  }
  if(flag==FALSE)
  {
   queryList.append(new queryWindow(msg.nick));
   tmp=queryList.current();
   connect(tmp,SIGNAL(newInput(QString)),svr,SLOT(userInput(QString)));
   connect(tmp,SIGNAL(killMe(QString)),SLOT(delQuery(QString)));
   if(msg.text!="")
    tmp->putLine("<"+msg.nick+"> "+msg.text);
  }
 }
}

void MainWidget::delQuery(QString nick)
{
 queryWindow *tmp;
 tmp=queryList.first();
 while(tmp!=0)
 {
  if(nick==tmp->getNick())
  {
   disconnect(tmp);
   queryList.remove();
   break;
  }
  else
   tmp=queryList.next();
 }
}

void MainWidget::handleNickChange(QString old_n, QString new_n)
{
 queryWindow *qtmp;
 channelWindow *ctmp;

 qtmp=queryList.first();
 while(qtmp!=0)
 {
  if(old_n==qtmp->getNick())
  {
   qtmp->changeNick(new_n);
   break;
  }
  else
   qtmp=queryList.next();
 }

 ctmp=channelList.first();
 while(ctmp!=0)
 {
  if(ctmp->nickExists(old_n))
   ctmp->nickChange(old_n, new_n);
  ctmp=channelList.next();
 }
}

void MainWidget::putNotice(ircMsg msg)
{
 QString str;
 if(msg.nick=="")
  str="-NOTICE- "+msg.text;
 else
  str="-"+msg.nick+"- "+msg.text;
 putLine(str);
}



int main(int argc, char **argv)
{
  QApplication App(argc,argv);
  MainWidget MW;
  App.setMainWidget(&MW);
  MW.show();
  return App.exec();
}
