#include <stdio.h>
#include <qapp.h>
#include <qlistbox.h>
#include <qlined.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlist.h>

#include "setup.h"

#define ADD  0
#define EDIT 1

setupDialog::setupDialog(QWidget *parent, const char *name)
           :QDialog(parent,name,TRUE)
{
  slist.setAutoDelete(TRUE);
  serverData entry;
  serverEntry *temp;
  setCaption("Server Setup");
  serverListbox = new QListBox(this,"serverListbox");  
  serverListbox->setAutoUpdate(TRUE);
  
  entry.name="Local Server";
  entry.network="TestNet";
  entry.address="localhost";
  entry.port=6667;
  slist.append(new serverEntry(entry));
      
  for (temp=slist.first();temp!=0;temp=slist.next())
    {
      QString str;
      entry=temp->data();
      str.sprintf("%s (%s)",entry.name,entry.network);
      serverListbox->insertItem(str);
    }
  serverListbox->setGeometry(5,5,300,200);
  serverListbox->setCurrentItem(0);
  itemSelected=0;
  connect(serverListbox,SIGNAL(highlighted(int)),SLOT(serverSelected(int)));
  
  nickLine = new QLineEdit(this,"nickLine");
  nickLine->setGeometry(80,210,220,30);

  nickLabel = new QLabel("Nick:",this,"nickLabel");
  nickLabel->setGeometry(5,210,75,30);
  
  realLine = new QLineEdit(this,"realLine");
  realLine->setGeometry(80,240,220,30);

  realLabel = new QLabel("Real name:",this,"realLabel");
  realLabel->setGeometry(5,240,75,30);
  
  addButton = new QPushButton("Add",this,"addButton");
  addButton->setGeometry(310,25,50,20);
  connect(addButton, SIGNAL(clicked()), SLOT(add()));
  
  editButton = new QPushButton("Edit",this,"editButton");
  editButton->setGeometry(310,50,50,20);
  connect(editButton, SIGNAL(clicked()), SLOT(edit()));
  
  deleteButton = new QPushButton("Delete",this,"deleteButton");
  deleteButton->setGeometry(310,75,50,20);

  dismissButton = new QPushButton("Dismiss",this,"dismissButton");
  dismissButton->setGeometry(310,240,50,20);
  connect(dismissButton, SIGNAL(clicked()), SLOT(accept()));
}

setupDialog::~setupDialog()
{
}


void setupDialog::serverSelected(int index)
{
  itemSelected=index;
  printf("Selected: %d",itemSelected);
}

void setupDialog::add()
{
  serverData temp,entry;
  temp.name="";
  temp.network="";
  temp.address="";
  temp.port=6667;
  settingsDialog m(this,"settingsDialog",ADD,temp);
  m.exec();
  temp=m.getData();
  slist.append(new serverEntry(temp));
  QString str;
  entry=temp;
  str.sprintf("%s (%s)",entry.name,entry.network);
  serverListbox->insertItem(str);  
}

void setupDialog::edit()
{
  serverData temp,entry;
  serverEntry *temp1;
  temp=slist.at(itemSelected)->data();
  settingsDialog m(this,"settingsDialog",EDIT,temp);
  m.exec();
  temp=m.getData();
  slist.remove(itemSelected);
//  slist.at(itemSelected)->setData(temp);
  slist.insert(itemSelected,new serverEntry(temp));
  serverListbox->clear();
  for (temp1=slist.first();temp1!=0;temp1=slist.next())
    {
      QString str;
      entry=temp1->data();
      str.sprintf("%s (%s)",entry.name,entry.network);
      serverListbox->insertItem(str);
    }
  
}



settingsDialog::settingsDialog(QWidget *parent, const char *name, int action, serverData info)
           :QDialog(parent,name,TRUE)
{
  setCaption("Server Settings");

  QLabel *nameLabel = new QLabel("Name:",this,"nameLabel");
  nameLabel->setGeometry(5,5,70,20);
  nameLine = new QLineEdit(this,"nameLine");
  nameLine->setGeometry(80,5,100,20);
  nameLine->setText(info.name);
  
  QLabel *netLabel = new QLabel("Network:",this,"netLabel");
  netLabel->setGeometry(5,30,70,20);
  netLine = new QLineEdit(this,"netLine");
  netLine->setGeometry(80,30,100,20);
  netLine->setText(info.network);
  
  QLabel *addressLabel = new QLabel("Address:",this,"addressLabel");
  addressLabel->setGeometry(5,55,70,20);
  addressLine = new QLineEdit(this,"addressLine");
  addressLine->setGeometry(80,55,100,20);
  addressLine->setText(info.address);
  
  QLabel *portLabel = new QLabel("Port:",this,"portLabel");
  portLabel->setGeometry(5,80,70,20);
  portLine = new QLineEdit(this,"portLine");
  portLine->setGeometry(80,80,100,20);

  QLabel *loginLabel = new QLabel("Login:",this,"loginLabel");
  loginLabel->setGeometry(5,105,70,20);
  QLineEdit *loginLine = new QLineEdit(this,"loginLine");
  loginLine->setGeometry(80,105,100,20);

  QLabel *passwdLabel = new QLabel("Password:",this,"passwdLabel");
  passwdLabel->setGeometry(5,130,70,20);
  QLineEdit *passwdLine = new QLineEdit(this,"passwdLine");
  passwdLine->setGeometry(80,130,100,20);

  QPushButton *okButton = new QPushButton("Ok",this,"okButton");
  okButton->setGeometry(200,10,60,30);
  connect(okButton, SIGNAL(clicked()), SLOT(accept()));

  QPushButton *cancelButton = new QPushButton("Cancel",this,"cancelButton");
  cancelButton->setGeometry(200,50,60,30);
  connect(cancelButton, SIGNAL(clicked()), SLOT(reject()));
}

serverData settingsDialog::getData()
{
  serverData temp;
  temp.name=nameLine->text();
  temp.network=netLine->text();
  temp.address=addressLine->text();
  temp.port=(int)portLine->text();
  return(temp);
}
