#include <iostream.h>
#include <stdio.h>
#include <netdb.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <qobject.h>
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qsocketnotifier.h>

typedef struct
{
 QString cmd;
 QString text;
 QString channel;
 QString nick;
 QString address;
} ircMsg;

class ircServer : public QObject
{
 Q_OBJECT

 public:
  ircServer(QObject *parent, const char *name);
  ~ircServer();
  int connect_to(QString host, unsigned short port);
  void disconnect_from();
  void send_to(QString text);
  QString get_from();
  
  void sendNick();
  void sendUser();

  void setNick(QString s) { nick=s; }
  void setName(QString s) { name=s; }
  void setUser(QString s) { user=s; }
  void setHost(QString s) { host=s; }
  void setDomain(QString s) { domain=s; }

  bool isConnected() { return connected; }

  QString getNick() { return nick; }        

 signals:
  void generalMsg(ircMsg);
  void queryMsg(ircMsg);

  void channelMsg(ircMsg);
  void channelTopic(QString,QString); // channel, topic

  void motdMsg(ircMsg);
  void noticeMsg(ircMsg);
  void nickChange(QString,QString); // old nick, new nick
  void newChannel(QString);
  void delChannel(QString);
  void joinChannel(QString,QString); // channel, nick
  void partChannel(QString,QString); // channel, nick
  void quitServer(QString,QString); // nick, quit message
  
 public slots:
  void newData();
  void userInput(QString line);

 private:
  int unit;
  char s_host[BUFSIZ];
  unsigned short s_port;
  QFile sockin, sockout;
  fd_set in_set;
  bool connected;
  QString nick, name;
  QString user, host, domain;
  QSocketNotifier *snr;
};

