// Server interaction object

#include "server.h"

ircServer::ircServer(QObject *parent, const char *name)
          :QObject(parent,name)
{
 nick="tester";
 name="tester";
 user="tester";
 host="localhost";
 domain="evcom.net";
 connected=FALSE;
}

ircServer::~ircServer()
{
}

int ircServer::connect_to(QString host, unsigned short port)
{
  struct sockaddr_in    sin;
//  struct servent        *sp;
  struct hostent        *hp;

  if ((hp=gethostbyname(host)) == NULL)
  {
   printf("Error getting hostname\n");
   connected=FALSE;
   return 0;
  }
  bzero((char *)&sin, sizeof(sin));
  bcopy(hp->h_addr, (char *)&sin.sin_addr,hp->h_length);
  sin.sin_family=AF_INET;
  sin.sin_port = htons(port);
  if((unit=socket(AF_INET,SOCK_STREAM,0)) < 0)
  {
    printf("Error getting socket\n");
    connected=FALSE;
    return 0;
  }
  if(::connect(unit,(struct sockaddr *)&sin,sizeof(sin)) < 0)
  {
   printf("Error connecting\n");
   connected=FALSE;
   return 0;
  }
  fcntl(unit,F_SETFL,O_NONBLOCK);
//  sockin = new QTextStream(fdopen(unit,"r"),IO_ReadOnly);
//  sockout = fdopen(unit,"w"),IO_WriteOnly;

  sockin.open(IO_ReadOnly,unit);
  sockout.open(IO_WriteOnly,unit);

  connected=TRUE;

  snr = new QSocketNotifier(unit, QSocketNotifier::Read, this);
  connect(snr, SIGNAL(activated(int)), this, SLOT(newData()));
  snr->setEnabled(TRUE);
  sendNick();
  sendUser();
  return 1;
}

void ircServer::disconnect_from()
{
 disconnect(snr, SIGNAL(activated(int)), this, SLOT(newData()));
 delete(snr);
 snr=NULL;
 sockin.close();
 sockout.close();
 close(unit);
 connected=FALSE;
}

void ircServer::send_to(QString text)
{
 if(connected)
 {
  sockout.writeBlock(text,text.length());
// puts("--> "+text);
 }
}

QString ircServer::get_from()
{
// char buf[8192];
// QString buf1;
// read(snr->socket(),buf,8192);
// fgets(buf,8192,sockin);
// buf1=buf;
// fflush(sockin);
// return(buf1);

// QString buf;
// sockin >> buf;
// return(buf);

// QTextStream *s;
// s = new QTextStream(sockin,IO_ReadOnly);

// fgets(buf,8192,sockin);
// fflush(sockin);
// QString buf(8192);
// sockin.readBlock(buf,8192);
// sockin.flush();

 QTextStream t(&sockin);
 QString s;
 s=t.readLine();
// puts("*> "+s);
 return(s);
}

void ircServer::sendNick()
{
 QString str;
 str="NICK "+nick+"\n";
 send_to(str);
}

void ircServer::sendUser()
{
// QString str;
// puts(name);
// str="USER "+user+" "+host+" "+domain;
// str+=" :"+name+"\n";
 send_to("USER tester localhost evcom.net :Test Program\n");
}

void ircServer::userInput(QString line)
{
 QString cmd,param,str;
 if(line[0]=='/')
 {
  // divide string into command and parameter strings
  if(line.contains(' '))
  {
   cmd=line.mid(1,line.find(' ')-1);
   cmd=cmd.upper();
   param=line.right(line.length()-line.find(' ')-1);
  }
  else
   cmd=line.right(line.length()-1);

  // interpret commands
  if(cmd=="RAW")
  {
   send_to(param+"\n");
  }
  else if(cmd=="QUIT")
  {
   send_to("QUIT :"+param+"\n");
  }
  
  else if(cmd=="SERVER")
  {
   str="6667";
   if(param.contains(' '))
   {
    str=param.right(param.length()-param.find(' ')-1);
    param=param.left(param.find(' '));
    if(str.length()<1)
     str="6667";
   }
   if(connected)
   {
    send_to("QUIT :Switching servers ("+param+")\n");
    disconnect_from();
   }
   connect_to(param,str.toUInt());
  }
  
  else if(cmd=="MSG")
  {
   if(param.contains(' '))
    param=param.left(param.find(' '))+" :"
         +param.right(param.length()-param.find(' ')-1);
   send_to("PRIVMSG "+param+"\n");
  }
  else if((cmd=="CTCP")&&(param.contains(' '))) //handle CTCP
  {
   str=param.left(param.find(' '));
   param=param.right(param.length()-param.find(' ')-1);
   param=param.upper();
   send_to("PRIVMSG "+str+" :\001"+param+"\001\n");
  }
  else if(cmd=="QUERY")
  {
   ircMsg msg;
   msg.nick=param;
   msg.text="";
   msg.channel="";
   emit queryMsg(msg);
  }
  else
  {
   send_to(cmd+" "+param+"\n");
  }

 }
}


void ircServer::newData()
{
 ircMsg msg;
 QString line,cmd,temp,rest;

 line=get_from();
// puts(line);

// new parser using technique of extracting the data from
// the server and then interpreting it's meaning
 msg.cmd="";
 msg.nick="";
 msg.channel="";
// extract and parse the prefix
 if(line[0]==':')
 {
  temp=line.right(line.length()-1); // chop off the ':'
  line=line.right(line.length()-line.find(' ')-1); // chop the addy off
  temp=temp.left(temp.find(' ')); // make temp just the addy
  // parse prefix for address and nick if applicable
  if(temp.contains('!') > 0)
  {
   msg.nick=temp.left(temp.find('!'));
   msg.address=temp.right(temp.length()-temp.find('!')-1);
  }
  else
  {
   msg.nick="";
   msg.address=temp;
  }
 }
 else
 {
  msg.nick="";
  msg.address="";
 }
// extract the command
 msg.cmd=line.left(line.find(' ')); // record the numeric
 line=line.right(line.length()-line.find(' ')-1); // chop off the numeric

// rip off the your nick or channel from the message if it is there
 if((msg.address!="")&&(line.contains(' ')))
 {
  msg.channel=line.left(line.find(' '));
  if((!msg.channel.contains('#'))&&(!msg.channel.contains('&')))
   msg.channel="";
  line=line.right(line.length()-line.find(' ')-1);
 }

// automatically respond to pings

 if(msg.cmd=="PING")
 {
  send_to("PONG "+line+"\n");
  msg.text="PING? PONG!\n";
  emit generalMsg(msg);
 }

 else if((msg.cmd=="NOTICE")&&(line[1]!=0x01))
 {
  if(line.contains(nick,FALSE))
   line=line.right(line.length()-line.find(' ')-1);
  line=line.right(line.length()-1);
  msg.text=line;
  noticeMsg(msg);
 }

 else if((msg.cmd=="001")||(msg.cmd=="002")||(msg.cmd=="003")
       ||(msg.cmd=="251")||(msg.cmd=="255"))
 {
  msg.text=line.right(line.length()-1); // chop off leading ':'
  emit generalMsg(msg);
 }

 else if((msg.cmd=="252")||(msg.cmd=="253")||(msg.cmd=="254"))
 {
  msg.text=line.left(line.find(':')) // remove mid-line ':'
                    +line.right(line.length()-line.find(':')-1);
  emit generalMsg(msg);
 }

 else if((msg.cmd=="375")||(msg.cmd=="372")||(msg.cmd=="376"))
 {
  msg.text=line.right(line.length()-1); // chop off leading ':'
  emit generalMsg(msg);
 }

 else if((msg.cmd=="PRIVMSG")&&(line[1]==0x01) //handle CTCP query
                             &&(line[line.length()-1]==0x01))
 {
  temp=line.right(line.length()-line.find('\001')-1);
  temp=temp.left(temp.find('\001'));
  if(temp=="VERSION")
   send_to("NOTICE "+msg.nick+" :\001VERSION xIRCh v0.11\001\n");
  msg.text="[CTCP "+temp+"]";
  emit generalMsg(msg);
 }

 else if((msg.cmd=="NOTICE")&&(line[1]==0x01) //handle CTCP reply
                             &&(line[line.length()-1]==0x01))
 {
  temp=line.right(line.length()-line.find('\001')-1);
  temp=temp.left(temp.find('\001'));
  if(temp.contains(' '))
   msg.text="[CTCP "+temp.left(temp.find(' '))+" Reply] "
           +temp.right(temp.length()-temp.find(' ')-1);
  else
   msg.text="[CTCP "+temp+" Reply]";
  emit generalMsg(msg);
 }

 else if((msg.cmd=="PRIVMSG")&&(msg.channel=="")) // private message
 {
  msg.text=line.right(line.length()-1);
  emit queryMsg(msg);
 }

 else if((msg.cmd=="PRIVMSG")&&(msg.channel!="")) // channel message
 {
  msg.text=line.right(line.length()-1);
  emit channelMsg(msg);
 }

 else if(msg.cmd=="NICK")
 {
  msg.text=line.right(line.length()-1);
  emit nickChange(msg.nick,msg.text);
 }

 else if(msg.cmd=="JOIN")
 {
  temp=line.right(line.length()-1);
  if(msg.nick==nick)
  {
   emit newChannel(temp);
  }
  else
   emit joinChannel(temp,msg.nick);
 }

 else if(msg.cmd=="353") // names list
 {
//  puts(line);
  rest=line.right(line.length()-2); // chop off "= "
  msg.channel=rest.left(rest.find(" "));
  rest=rest.right(rest.length()-rest.find(":")-1)+" ";
//  puts("'"+msg.channel+"'"); puts(rest); puts("-->");
  while(rest.contains(' ')>1)
  {
   temp=rest.left(rest.find(' '));
   rest=rest.right(rest.length()-rest.find(' ')-1);
//   puts(temp);
   emit joinChannel(msg.channel,temp);
  }
//  puts("--------");
 }

 else if(msg.cmd=="332") // channel topic
 {
//  puts("'"+msg.channel+"' - '"+line+"'");
  msg.channel=line.left(line.find(' '));
  temp=line.right(line.length()-line.find(':')-1);
//  puts("'"+msg.channel+"' --> '"+temp+"'"); puts("--------");
  emit channelTopic(msg.channel,temp);
 }

 else if(msg.cmd=="TOPIC") // channel topic changed
 {
//  puts("'"+msg.channel+"' - '"+line+"'");
//  msg.channel=line.left(line.find(' '));
  temp=line.right(line.length()-line.find(':')-1);
//  puts("'"+msg.channel+"' --> '"+temp+"'"); puts("--------");
  emit channelTopic(msg.channel,temp);
 }

 else if(msg.cmd=="PART")
 {
//  temp=line.right(line.length()-1);
  if(msg.nick==nick)
   emit delChannel(line);
  else
   emit partChannel(line,msg.nick);
 }

 else if(msg.cmd=="QUIT")
 {
  temp=line.right(line.length()-1);
  emit quitServer(msg.nick,temp);
 }

 else if((msg.cmd="ERROR")&&(line.contains(":Closing Link:")))
 {
  msg.text=line.right(line.length()-1);
  emit generalMsg(msg);
  disconnect_from();
 }
 else
 {
  msg.text=line;
  emit generalMsg(msg);
 }

// parser debug output
// puts(msg.address);
// puts(msg.cmd);
// puts(msg.text);
// printf("----\n");

}
