// Query window object

#include "query.h"

queryWindow::queryWindow(QString n, QWidget *parent, const char *name)
            : QWidget(parent,name)
{
  setCaption(n);
  nick=n;
  setMinimumSize(500,171);
  setMaximumSize(500,171);

  inputLine = new QLineEdit(this,"Input Line");
  CHECK_PTR(inputLine);
  inputLine->setGeometry(1,150,498,20);
  connect(inputLine,SIGNAL(returnPressed()),SLOT(processInput()));
  
  messageWindow = new OutputWidget(this,"Status Window");
  CHECK_PTR(messageWindow);
  messageWindow->setGeometry(1,1,498,145);
//  messageWindow->setReadOnly(TRUE);
//  messageWindow->setAutoUpdate(TRUE);
  show();
}

queryWindow::~queryWindow()
{
 delete(inputLine);
 delete(messageWindow);
}

void queryWindow::putLine(QString line)
{
 messageWindow->InsertText(line);
 messageWindow->NewLine();
// messageWindow->setCursorPosition(messageWindow->numLines(),0,FALSE);
// messageWindow->repaint();
}

void queryWindow::closeEvent(QCloseEvent *e)
{
 e->accept();
 emit killMe(nick);
}

void queryWindow::processInput()
{
 QString str;
 str=inputLine->text();
 if(str[0]=='/')
  emit newInput(str);
 else
 {
  putLine("> "+str);
  emit newInput("/msg "+nick+" "+str);
 }
 inputLine->setText("");
}

