#ifndef OUTPUT_H
#define OUTPUT_H

#include <stdlib.h>

#include <qstring.h>
#include <qevent.h>
#include <qwidget.h>
#include <qcolor.h>
#include <qpainter.h>
#include <qlist.h>
#include <qrect.h>
#include <qscrbar.h>
#include <qsize.h>
#include <qpaintd.h>
#include <qwmatrix.h>
#include <qpixmap.h>
#include <qapp.h>
#include <qpicture.h>
#include <qpoint.h>
#include <qtablevw.h>

class Object 
{
public:
    Object() { isSelected = FALSE; x1 = -1; x2 = -1; }
    enum {STRING, PIXMAP} type;
    void SetSelected(bool yn, int startX=0, int endX=0) { isSelected = yn; x1 = startX; x2 = endX; }
    bool IsSelected() { return isSelected; }
    int StartX() { return x1; }
    int EndX() { return x2; }
    virtual int Width() { return 0; }
    virtual int Height() { return 0; }
protected:
    bool isSelected;
    int x1, x2;
};

class ObjectString : public Object, public QString
{
 private:
    QFont font;
    QColor color, bgColor;
    bool inverse;
public:
    ObjectString(const char *txt=0);
    virtual ~ObjectString();
    QFont &Font() { return font; }
    QColor &Color() { return color; }
    void SetFont(QFont &fnt) { font = fnt; }
    void SetColor(QColor &c) { color = c; }
    void SetBgColor(QColor &c) { bgColor = c; }
    void SetInverse(bool yn) { inverse = yn; }
    bool IsInverse() { return inverse; }
    inline void DrawText(QPainter *, const char *word, int x, int y);
    virtual int Width();
    virtual int Height();
};

class ObjectPixmap : public Object, public QPixmap
{
public:
    ObjectPixmap(const char *filename=0);
    virtual ~ObjectPixmap();
    virtual int Width() { return width(); }
    virtual int Height() { return height(); }
};

class OutputWidget;

class OutputLine
{
    friend class OutputWidget;
public:
    OutputLine();
    virtual ~OutputLine();
    void InsertObject(Object *);
    int Height() { return height; }
    int ActualHeight() { return height*numLines; }
    int NumLines() { return numLines; }
    Object *ObjectAt(int x);
    void SelectText(int x1, int x2);
    void UnselectText();
protected:
    void PaintObjects(QPainter *, int maxWidth);
    int NextSpace(int startingIndex);
    void DrawObject (int, QPainter *, int &, int &, int);
private:
    QList<Object> *objects;
    int height;
    int numLines;
};

class OutputWidget : public QTableView
{
    Q_OBJECT
private:
    void NewTextObject();
    // void AdjustScrollBar();
    QList<OutputLine> *lines;
    ObjectString *textObj; // the current text object
    QFont currentFont;
    QColor currentColor;
    QColor currentBgColor;
    bool settingsChanged;
    int offx, offy; // offsets
    bool caching;
    bool isTextSelected;
    QList <QString> *picNames;
    QList <ObjectPixmap> *pics;
    // QScrollBar *vertScroll;
    QPoint selectPoint;
    QRect selectRect;
    int docHeight;
    bool updateAll; // after a resize we need to update all lines
    bool inverse;
    bool scrollPixmap;
    QPixmap bgPixmap;
    const QScrollBar *scrollBar;
private slots:
    void Update();
public:
    OutputWidget(QWidget *parent=0,const char *name=0);  
    ~OutputWidget();
    void mousePressEvent(QMouseEvent *);
    QFont &CurrentFont() { return currentFont; }
    QColor &CurrentColor() { return currentColor; }
    Object *ObjectAt(int x, int y);
    virtual void setBackgroundPixmap(const QPixmap &p) { bgPixmap = p; }
    void clearAll();
public slots:
    void InsertText(const char *text);
    void NewLine();
    void InsertPixmap(const char *filename);
    void SetCurrentFont(QFont &f) { currentFont = f; }
    void SetCurrentColor (const QColor &c) { currentColor = c; }
    void SetCurrentBgColor (const QColor &c) { currentBgColor = c; }
    void SetInverse(bool yn) { inverse = yn; }
    bool IsInverse() { return inverse; }
    void EnableCaching(bool yn) { caching = yn; }
    void UpdateLastRow();
    void SelectText(int x1, int y1, int x2, int y2);
    void PrevPage();
    void NextPage();
signals:
    void Popup(QPoint);
protected:
    void DrawBackground(QPainter *, int row);
    virtual int cellHeight(int);
    virtual int totalHeight();
    virtual void paintCell(QPainter *, int  row, int  col);
    virtual void resizeEvent(QResizeEvent *);
};
#endif OUPTUT_H
 