
#include <qwidget.h>
#include <qlistbox.h>
#include <qlined.h>
//#include <qmlined.h>
#include <qstrlist.h>

#include "output.h"

class channelWindow : public QWidget
{
 Q_OBJECT

 public:
  channelWindow(QString n, QWidget *parent=0, const char *name=0);
  ~channelWindow();

  QString getName() { return c_name; }

  void nickJoin(QString n);
  void nickPart(QString n);
  bool nickExists(QString n);
  void nickChange(QString n_old, QString n_new);

 public slots:
  void putLine(QString line);
  void processInput();

  void setTopic(QString t);
  
 signals:
  void newInput(QString);

 protected:
  void closeEvent(QCloseEvent *e);

 private:
  QString c_name, c_topic;
  QLineEdit *inputLine;
  QListBox *nickList;
  OutputWidget *messageWindow;  
};
