// channel class

#include "channel.h"


channelWindow::channelWindow(QString n, QWidget *parent, const char *name)
	      : QWidget(parent, name)
{
 setCaption(n);
 c_name=n;

 inputLine = new QLineEdit(this, "inputLine");
 inputLine->setGeometry(0, 380, 600, 20);
 inputLine->setMinimumSize(10, 10);
 inputLine->setMaximumSize(32767, 32767);
 inputLine->setText("");
 inputLine->setMaxLength(32767);
 inputLine->setEchoMode(QLineEdit::Normal);
 inputLine->setFrame(TRUE);

 nickList = new QListBox(this, "nickList");
 nickList->setGeometry(500, 0, 100, 380);
 nickList->setMinimumSize(10, 10);
 nickList->setMaximumSize(32767, 32767);
 nickList->setFrameStyle(51);
 nickList->setLineWidth(2);
 nickList->setAutoBottomScrollBar(FALSE);
 nickList->setMultiSelection(FALSE);

 messageWindow = new OutputWidget(this, "messageWindow");
 messageWindow->setGeometry(0, 0, 500, 380);
 messageWindow->setMinimumSize(10, 10);
 messageWindow->setMaximumSize(32767, 32767);
// messageWindow->insertLine("");
// messageWindow->setReadOnly(TRUE);
// messageWindow->setOverwriteMode(FALSE);

 resize(600,400);
 setMinimumSize(600, 400);
 setMaximumSize(600, 400);

 connect(inputLine,SIGNAL(returnPressed()),SLOT(processInput()));
 show();
}


channelWindow::~channelWindow()
{
 delete(inputLine);
 delete(nickList);
 delete(messageWindow);
}

void channelWindow::putLine(QString line)
{
 messageWindow->InsertText(line);
 messageWindow->NewLine();
// messageWindow->setCursorPosition(messageWindow->numLines(),0,FALSE);
// messageWindow->repaint();
}

void channelWindow::closeEvent(QCloseEvent *e)
{
 e->accept();
 emit newInput("/part "+c_name+"\n");
}

void channelWindow::processInput()
{
 QString str;
 str=inputLine->text();
 if(str[0]=='/')
  emit newInput(str);
 else
 {
  putLine("> "+str);
  emit newInput("/msg "+c_name+" "+str);
 }
 inputLine->setText("");
}

void channelWindow::setTopic(QString t)
{
 c_topic=t;
 setCaption(c_name+": "+c_topic);
}

void channelWindow::nickJoin(QString n)
{
 nickList->inSort(n);
}

void channelWindow::nickPart(QString n)
{
 unsigned int i;
 for(i=0;i<=nickList->count();i++)
  if(nickList->text(i)==n)
  {
   nickList->removeItem(i);
   break;
  }
}

bool channelWindow::nickExists(QString n)
{
 unsigned int i;
 QString temp;
 for(i=0;i<=nickList->count();i++)
 {
  temp=nickList->text(i);
//  if((temp.contains('@'))||(temp.contains('+')))
//   temp=temp.right(temp.length()-1);
  if(temp==n)
   return TRUE;
 }
 return FALSE;
}

void channelWindow::nickChange(QString n_old, QString n_new)
{
 nickPart(n_old);
 nickJoin(n_new);
}
